<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

function safe_base64_decode($base64Text) {
    $base64Text = preg_replace('/\s+/', '', $base64Text);
    if (!preg_match('/^[A-Za-z0-9+\/=]*$/', $base64Text)) {
        throw new Exception("Invalid Base64 string");
    }
    $decoded = base64_decode($base64Text, true); 
    if ($decoded === false) {
        throw new Exception("Base64 decode failed");
    }
    return $decoded;
}

function extract_credentials($url) {
    $parts = parse_url($url);

    if (!isset($parts['query'])) {
        return null; 
    }

    parse_str($parts['query'], $query);
    $username = isset($query['username']) ? $query['username'] : null;
    $password = isset($query['password']) ? $query['password'] : null;

    return [
        "username" => $username,
        "password" => $password
    ];
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $post_data = file_get_contents('php://input');
    $json_data = json_decode($post_data, true);
    $decode_Data = isset($json_data['data']) ? $json_data['data'] : 'null';
    $json_data_first = safe_base64_decode($decode_Data);
    $json_data_decode = json_decode($json_data_first, true);

	$mac_address_get = isset($json_data_decode['mac_address']) ? $json_data_decode['mac_address'] : 'null';
	$playlist_id_get = isset($json_data_decode['playlist_id']) ? $json_data_decode['playlist_id'] : 'null';
    
    
    porgress($mac_address_get , $playlist_id_get);
}

function porgress($mac_address_get , $PlaylistID){
    $db = new SQLite3('./.db.db');
    
    if($mac_address_get == ''||$PlaylistID == ''){
        errorecho();
    }else{
        deleteplst($db ,$PlaylistID );
    }
    
}

function deleteplst($db, $PlaylistID) {
    $stmt = $db->prepare("DELETE FROM ibof WHERE plid = :plid");
    $stmt->bindValue(':plid', $PlaylistID, SQLITE3_TEXT);
    $result = $stmt->execute();

    if ($result) {
        sucsessecho();
    } else {
        errorecho();
    }
}



function errorecho (){
    $response = ["status" => false, "message" => "A playlist not deleted!"];
    header('Content-type: application/json; charset=UTF-8');
    echo json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
}

function sucsessecho(){
    
    $message =[
    'status' => true,
    'message' => 'A playlist deleted!',
    'details' => [
        'n' => 1,
        'electionId' => '7fffffff00000000000003e8',
        'opTime' => [
            'ts' => '7542051318685237295',
            't' => 1000
        ],
        'ok' => 1,
        '$clusterTime' => [
            'clusterTime' => '7542051318685237296',
            'signature' => [
                'hash' => 'h7f8dPPFK/FJaxnU6d6V8kko4Wg=',
                'keyId' => '7501758787372449847'
            ]
        ],
        'operationTime' => '7542051318685237295',
        'deletedCount' => 1
        ]
    ];
    
    header('Content-type: application/json; charset=UTF-8');
    echo json_encode($message, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
}

?>