<?php     
include(__DIR__ . '/../includes/functions.php');    
session_start();

$playlistname = 'ran';
$getmac = isset($_GET['mac']) ? $_GET['mac'] : '';
$getuuid = isset($_GET['uuid']) ? $_GET['uuid'] : '';
$getname = isset($_GET['name']) ? $_GET['name'] : '';
$getuname = isset($_GET['uname']) ? $_GET['uname'] : '';
$getpassw = isset($_GET['pword']) ? $_GET['pword'] : '';

function PlaylistID() {
    $timezone = @date_default_timezone_get();
    if (!$timezone) {
        $timezone = 'UTC';
    }
    date_default_timezone_set($timezone);
    $time = date('Y-m-d H:i:s');
    $mix = md5($time).$time;
    return hash('sha256', $mix);
}

function getCurrentDateTimeAuto() {
    $timezone = @date_default_timezone_get();
    if (!$timezone) {
        $timezone = 'UTC';
    }
    date_default_timezone_set($timezone);
    return date('Y-m-d H:i:s');
}

function getRandomIPTVName() {
    $names = [
        "📺 UltraStream",
        "🎬 CineMax",
        "📡 NetWave",
        "🔥 FireStream",
        "🌐 GlobeTV",
        "🎥 MovieZone",
        "🌟 StarView",
        "📻 RadioCast",
        "💎 DiamondTV",
        "🌊 OceanStream",
        "🚀 RocketTV",
        "🎶 MusicFlow",
        "🍿 PopcornTime",
        "🛰️ SatView",
        "🎯 TargetStream",
        "📽️ FilmBox",
        "💫 GalaxyCast",
        "⚡ FlashStream",
        "🏆 PrimeTV",
        "🖥️ StreamX",
        "🌈 RainbowTV",
        "🎉 PartyStream",
        "🦅 EagleCast",
        "🏝️ IslandView",
        "🔮 VisionTV",
        "🎤 StageCast",
        "📦 BoxStream",
        "🛡️ ShieldView",
        "🌌 SpaceStream",
        "💥 BoomCast",
        "🎧 AudioWave",
        "🎭 DramaBox",
        "🌻 SunStream",
        "📊 InfoCast",
        "🐬 DolphinTV",
        "🪐 OrbitView",
        "🌴 TropicCast",
        "📜 StoryTV",
        "💃 DanceStream",
        "🥇 GoldCast"
    ];

    return $names[array_rand($names)];
}


if(empty($getname) || $getname == 'ran'){
    $playlistname = getRandomIPTVName(); 
}else{
    $playlistname = $getname;
}

echo saveplaylist(PlaylistID(),$playlistname,$getmac,$getuuid,$getuname,$getpassw,getCurrentDateTimeAuto(),getCurrentDateTimeAuto());



function saveplaylist($pid,$name,$mac,$dnsuuid,$username,$password,$cdate,$udate) {
    $db = new SQLite3('./.db.db');
    $stmt = $db->prepare("INSERT INTO ibof (plid, name, macad, uuid, username, password, cdate, udate, mark, protec) VALUES (:plid, :name, :macad, :uuid, :username, :password, :cdate, :udate, :mark, :protec)");
    
    $stmt->bindValue(':plid', $pid, SQLITE3_TEXT);
    $stmt->bindValue(':name', $name, SQLITE3_TEXT);
    $stmt->bindValue(':macad', $mac, SQLITE3_TEXT);
    $stmt->bindValue(':uuid', $dnsuuid, SQLITE3_TEXT);
    $stmt->bindValue(':username', $username, SQLITE3_TEXT);
    $stmt->bindValue(':password', $password, SQLITE3_TEXT);
    $stmt->bindValue(':cdate', $cdate, SQLITE3_TEXT);
    $stmt->bindValue(':udate', $udate, SQLITE3_TEXT);
    $stmt->bindValue(':mark', '0', SQLITE3_TEXT);
    $stmt->bindValue(':protec', '0', SQLITE3_TEXT);

    $result = $stmt->execute();

    if ($result) {
        return out(1,$name);
    } else {
        return out(2,$name);
    }
}

function out($status ,$name){
    $success = [
     'status' => 'success',
     'message' => "Successfully added the playlist ➤ $name"
     ];
     
    $error = [
     'status' => 'error',
     'message' => 'There was a problem. Please try again later.'
     ]; 
     
     if($status == 1){
         return json_encode($success);
     }else{
         return json_encode($error);
     }
}